---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-pstat - プロセス・スワップ・TTY統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/pstat/pstat.c` 63-82行目（enum定義、nlist配列）
- E-02: `usr.sbin/pstat/pstat.c` 103-201行目（main関数）
- E-03: `usr.sbin/pstat/pstat.c` 286-324行目（ttystates配列）
- E-04: `usr.sbin/pstat/pstat.c` 326-352行目（ttyprt関数）
- E-05: `usr.sbin/pstat/pstat.c` 354-412行目（filemode関数）
- E-06: `usr.sbin/pstat/pstat.c` 414-443行目（getfiles関数）
- E-07: `usr.sbin/pstat/pstat.c` 455-538行目（swap関連関数群）
- E-08: `usr.sbin/pstat/pstat.c` 540-597行目（swapmode関数群）
- E-09: `usr.sbin/pstat/pstat.c` 210-216行目（ファイルヘッダーフォーマット）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | argv[0]がswapinfoの場合にスワップモード固定 | E-02 (115-127行目) | ○ |
| C-02 | ファイルテーブルをKERN_FILE sysctlで取得 | E-06 (428-436行目) | ○ |
| C-03 | TTYデバイスをkern.ttys sysctlで取得 | E-04 (254-274行目) | ○ |
| C-04 | スワップ情報をvm.swap_info sysctlで取得 | E-08 (565行目) | ○ |
| C-05 | ファイルタイプはdtypes配列で文字列変換 | E-05 (361-362行目) | ○ |
| C-06 | FREAD/FWRITE/FAPPEND/FASYNCフラグをRWAI文字に変換 | E-05 (395-404行目) | ○ |
| C-07 | 32bit/64bitでファイルヘッダーフォーマットが異なる | E-09 (210-216行目), E-05 (388行目) | ○ |
| C-08 | TTY状態フラグをttystates配列で文字変換 | E-03 (286-324行目), E-04 (344-348行目) | ○ |
| C-09 | -hオプションでhumanize_number使用 | E-07 (489-498行目) | ○ |
| C-10 | CONVERTマクロでページ数→ブロック数変換 | E-07 (450行目) | ○ |
| C-11 | -Tオプションでサマリー出力（ファイル数+スワップ使用量） | E-05 (379-381行目), E-07 (529-532行目) | ○ |
| C-12 | kvm/sysctl両対応（ttymode_kvm/ttymode_sysctl） | E-04 (276-284行目) | ○ |
| C-13 | swapmode_kvm/swapmode_sysctlの切り替え | E-08 (590-597行目) | ○ |
| C-14 | xttyサイズ不一致チェック | E-04 (332-333行目) | ○ |
| C-15 | -nオプションでデバイス番号表示 | E-04 (334-336行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単一ファイルで完結し、全処理をソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] xfile構造体のバージョン互換性を確認
- [ ] xtty構造体のxt_size検証ロジックの妥当性を確認
- [ ] BLOCKSIZEバリエーション（-g,-k,-m）の動作を確認
